<!DOCTYPE html>
<!--[if lt IE 9 ]><html class="no-js oldie" lang="en"> <![endif]-->
<!--[if IE 9 ]><html class="no-js oldie ie9" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" lang="en">
<!--<![endif]-->

<head>

    <!--- basic page needs
   ================================================== -->
    <meta charset="utf-8">
    <title>Pakacha</title>
    <meta name="description" content="">
    <meta name="author" content="">

    <!-- mobile specific metas
   ================================================== -->
    <meta name="viewport" content="width=device-width, initial-scale=1"> 

    <!-- CSS
   ================================================== -->
    <link rel="stylesheet" href="{{ asset('css/base.css')}}">
    <link rel="stylesheet" href="{{ asset('css/vendor.css')}}">
    <link rel="stylesheet" href="{{ asset('css/main.css')}}">

    <!-- script
   ================================================== -->
    <script src="{{ asset('js/modernizr.js')}}"></script>
    <script src="{{ asset('js/pace.min.js')}}"></script>

    <!-- favicons
	================================================== -->
    <link rel="shortcut icon" href="images/logo.png" type="image/x-icon">
    <link rel="icon" href="images/logo.png" type="image/x-icon">

</head>

<body id="top">

    <!-- header 
   ================================================== -->
   <!-- <header id="header" class="row">   

   		<div class="header-logo">
	        <a href="index.html">Pakacha</a>
	    </div>

	   	<nav id="header-nav-wrap">
			<ul class="header-main-nav">
				<li class="current"><a class="smoothscroll"  href="#home" title="home">Home</a></li>
                <li><a class="smoothscroll"  href="#about" title="about">About</a></li>
				<li><a class="smoothscroll"  href="#pricing" title="pricing">Pricing</a></li>
				<li><a class="smoothscroll"  href="#testimonials" title="testimonials">Testimonials</a></li>
				<li><a class="smoothscroll"  href="#download" title="download">Download</a></li>	
			</ul>

            <a href="#" title="sign-up" class="button button-primary cta">Sign Up</a>
		</nav>

		<a class="header-menu-toggle" href="#"><span>Menu</span></a>    	
   	
   </header>  -->
   
   <!-- /header -->


   <!-- home
   ================================================== -->
   <section id="home" data-parallax="scroll" data-image-src="images/hero-bg.jpg" data-natural-width=3000 data-natural-height=2000>

        <div class="overlay"></div>
        <div class="home-content">        

            <div class="row contents">                     
                <div class="home-content-left">

                    <h3 data-aos="fade-up">Welcome to Pakacha </h3>

                    <h1 data-aos="fade-up">
                        Shop <br>
                        Delivery Service <br>
                        Amazing Products.
                    </h1>

                    <div class="buttons" data-aos="fade-up">
                        <a href="#download" class="smoothscroll button stroke">
                            <span class="icon-circle-down" aria-hidden="true"></span>
                            Download App
                        </a>
                        <a href="img/msonge.mp4" data-lity class="button stroke">
                            <span class="icon-play" aria-hidden="true"></span>
                            Watch Video
                        </a>
                    </div>                                         

                </div>

                <div class="home-image-right">
                    <img src="images/iphone.png" 
                        srcset="images/iphone.png 1x, images/iphone.png 2x"  
                        data-aos="fade-up">
                </div>
            </div>

        </div> <!-- end home-content -->

        <ul class="home-social-list">
            <li>
                <a href="#"><i class="fa fa-facebook-square"></i></a>
            </li>
            <li>
                <a href="#"><i class="fa fa-twitter"></i></a>
            </li>
            <li>
                <a href="#"><i class="fa fa-instagram"></i></a>
            </li>
            <li>
                <a href="#"><i class="fa fa-youtube-play"></i></a>
            </li>
        </ul>
        <!-- end home-social-list -->

        <div class="home-scrolldown">
            <a href="#about" class="scroll-icon smoothscroll">
                <span>Scroll Down</span>
                <i class="icon-arrow-right" aria-hidden="true"></i>
            </a>
        </div>

    </section> <!-- end home -->  


    <!-- about
    ================================================== -->
    <section id="about">

        <div class="row about-intro">

            <div class="col-four">
                <h1 class="intro-header" data-aos="fade-up">About Our App</h1>
            </div>
            <div class="col-eight">
                <p class="lead" data-aos="fade-up">
                    Pakacha is a farm fresh delivery service that we at Msonge provide on the East and West Coast of Zanzibar. 
                    We deliver products made and grown on the farm which includes chicken, eggs, coconut milk, peanut butter, 
                    Yoghurt, and so much more.
                </p>
            </div>                       
            
        </div>


        <div class="row about-how">
          
            <h1 class="intro-header" data-aos="fade-up">How The App Works?</h1>           

            <div class="about-how-content" data-aos="fade-up">
                <div class="about-how-steps block-1-2 block-tab-full group">

                    <div class="bgrid step" data-item="1">
                        <h3>Sign-Up & Login</h3>
                        <p>
                            Find and click Account button located on the right side on the bottom bar then click Register. Provide your 
                            active telephone number. You will be sent an OTP (One Time Password) to verify your contact. Proceed with 
                            further instructions to enable your account. 
                        </p> 
                    </div>

                    <div class="bgrid step" data-item="2">
                        <h3>Login</h3>
                        <p>
                            To make any purchase on Pakacha App you will be required 
                            to login into your account. Click Account button located on the right side on the bottom bar. Then click on Login 
                            button. Provide your phone number and password, then click Login.
                        </p> 
                    </div>               
               
                    <div class="bgrid step" data-item="3">
                        <h3>Shop</h3>
                        <p>
                            Select from a list of available items on the Pakacha App. Add items on your cart by pressing the plus/minus button 
                            which increases/decreases amount of items in your cart. A total amount on your cart will be displayed at the top of 
                            your screen.
                        </p> 
                    </div>

                    <div class="bgrid step" data-item="4">
                        <h3>Place & Date</h3>
                        <p>
                            After you are done with shopping, you will need to provide your location and date for delivery services. At the bottom 
                            you will find a Continue button. Click Continue to provide your location and date you wish to have your products delivered.
                        </p> 
                    </div>  

                    <div class="bgrid step" data-item="5">
                        <h3>Confirm Purchase</h3>
                        <p>
                            Lastly, you are required to select how you would like to pay. For now the only acceptable mode of payment is cash on delivery.
                            Select your mode of payment and click Submit button that will appear at the bottom of the page.
                        </p> 
                    </div>  

                </div>           
           </div> <!-- end about-how-content -->

        </div> <!-- end about-how -->

        <!--<div class="row about-bottom-image">-->

        <!--   <img src="images/app-screens-1200.png" -->
        <!--        srcset="images/app-screens-600.png 600w, -->
        <!--                images/app-screens-1200.png 1200w, -->
        <!--                images/app-screens-2800.png 2800w" -->
        <!--        sizes="(max-width: 2800px) 100vw, 2800px"-->
        <!--        alt="App Screenshots" data-aos="fade-up">-->

        <!--</div>  -->
        
        <!-- end about-bottom-image -->       
        
    </section> 
    
    <!-- end about -->  

    <!-- Testimonials Section
    ================================================== -->
    <section id="testimonials">

        <div class="row">
        </div>   	

        <div class="row owl-wrap">

            <div id="testimonial-slider"  data-aos="fade-up">

                <div class="slides owl-carousel">

                    <div>
                        <p>
                        Your work is going to fill a large part of your life, and the only way to be truly satisfied is
                        to do what you believe is great work. And the only way to do great work is to love what you do.
                        If you haven't found it yet, keep looking. Don't settle. As with all matters of the heart, you'll know when you find it. <br>
                        </p> 

                                        
                    </div> 

                </div> 
                
                 <!--end slides -->

            </div> 
            
             <!--end testimonial-slider -->
            
        </div> 
        
         <!--end flex-container -->

    </section> 
    
    <!-- end testimonials -->
    

    <!-- download
    ================================================== -->
    <section id="download">

        <div class="row">
            <div class="col-full">
                <h1 class="intro-header"  data-aos="fade-up">Download Our App Today!</h1>

                <ul class="download-badges">
                    <li><a href="https://apps.apple.com/tz/app/pakacha/id1508196721" title="" class="badge-appstore"  data-aos="fade-up">App Store</a></li>
                    <li><a href="https://play.google.com/store/apps/details?id=dev.hapa.pakacha" title="" class="badge-googleplay" data-aos="fade-up">Play Store</a></li>
                </ul>

            </div>
        </div>

    </section> <!-- end download -->    


    <!-- footer
    ================================================== -->
    <footer>

    <h4>Msonge Organic Family Farm</h4>

    </footer>
    <!-- end footer -->     	


    <div id="preloader"> 
    	<div id="loader"></div>
    </div>  

    <!-- Java Script
    ================================================== -->
    <script src="{{ asset('js/jquery-2.1.3.min.js')}}"></script>
    <script src="{{ asset('js/plugins.js')}}"></script>
    <script src="{{ asset('js/main2.js')}}"></script>

</body>

</html>