<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>Msonge Organic Family Farm - Farm Tour</title>

    <!-- Favicons -->
   <link href="img/logo.png" rel="icon">
   <link href="img/logo.png" rel="apple-touch-icon">

<!--
Template 2110 Character
http://www.tooplate.com/view/2110-character
-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:400,600">
    <!-- https://fonts.google.com/specimen/Open+Sans -->
    <link rel="stylesheet" href="/farmTour/css/all.min.css">
    <!-- https://fontawesome.com/ -->
    <link rel="stylesheet" href="/farmTour/css/tooplate-style.css">
</head>

<body class="tm-bg-dark">
    <main class="tm-container masonry">
        <div class="item tm-bg-white tm-block tm-block-left" data-desktop-seq-no="1" data-mobile-seq-no="1">
            <p class="tm-hero-text">
                &ldquo;Msonge Organic Family Farm offers a special tour to visit our Practical Permaculture Institute, see 
                the arrangement of the Permaculture training center, and visit our Msonge Organic Farm.&rdquo;
            </p>
            <header class="tm-block-brand">
                <div class="tm-bg-primary-dark tm-text-white tm-block-brand-inner">
                    <i class="fas fa-braille fa-3x"></i>
                    <h1 class="tm-brand-name">With Chef. Nachum</h1>
                </div>
            </header>
        </div>
        <div class="item" data-desktop-seq-no="2" data-mobile-seq-no="4">
            <img src="/farmTour/img/i9.jpg" alt="Image" class="tm-img-left">
        </div>
        <div class="item tm-bg-secondary tm-text-white tm-block tm-block-wider tm-block-pad tm-block-left-2" data-desktop-seq-no="3"
            data-mobile-seq-no="5">
            <i class="fas fa-award fa-4x tm-block-icon"></i>
            <p>
                On a good day like Monday or Thursday you will be lucky to see how we harvest organically grown vegetables and how we pack
                 our special Pakacha package for our lovely customers who like organically grown products.
            </p>
            <div class="tm-text-right">
                <!-- <a href="#" class="tm-btn tm-btn-small tm-btn-primary tm-mt">Read More</a> -->
            </div>
        </div>
        <div class="item" data-desktop-seq-no="4" data-mobile-seq-no="8">
            <img src="/farmTour/img/i1.jpg" alt="Image" class="tm-img-left">
        </div>
        <div class="tm-footer" id="tmFooter" data-desktop-seq-no="5" data-mobile-seq-no="9">
            <!-- <img src="/farmTour/img/qr-link-tooplate.png" alt="QR Code" class="tm-img-qr"> -->
            <div>
                <!-- <p class="tm-mb-small">Copyright &copy; Msonge Organic Family Farm</p> -->
                <p>Designed by <a rel="nofollow" href="https://www.kazicoltd.com" style="color: #D08C0F;">Kazi Company Ltd.</a></p>
            </div>
        </div>
        <div class="item" data-desktop-seq-no="6" data-mobile-seq-no="2">
            <img src="/farmTour/img/i2.jpg" alt="Image">
        </div>
        <div class="item tm-block-right" data-desktop-seq-no="7" data-mobile-seq-no="3">
            <div class="tm-block-right-inner tm-bg-primary-light tm-text-white tm-block tm-block-wider tm-block-pad">
                <header>
                    <h2 class="tm-text-uppercase" style="color: #668837;">
                        The Tour
                    </h2>
                </header>
                <p style="color: #668837;">
                    The tour includes harvesting some of the vegetables from the farm which are all grown organically.
                    
                </p>                    
                <p class="tm-mt tm-mb-small" style="color: #668837;">
                Some people prefer to eat organic food because it minimizes the exposure of non-organic food to other life forms. 
                Therefore, as part of the tour you will be taught how to prepare an African meal from organically grown products.
                </p>
                <!-- -->
            </div>
        </div>

        <div class="item" data-desktop-seq-no="8" data-mobile-seq-no="6">
            <img src="/farmTour/img/i8.jpg" alt="Image">
        </div>

        <div class="item tm-bg-white tm-block tm-form-section" data-desktop-seq-no="9" data-mobile-seq-no="7">
            <div class="tm-form-container tm-block-pad tm-pb-0">
                <header>
                    <h2 class="tm-text-uppercase tm-text-gray-light tm-mb">
                        Contact Us
                    </h2>
                </header>

                <p>
                P. O Box 1255 <br>
                Unguja, Zanzibar<br>
                Tanzania <br><br>
                <strong>Whatsapp: </strong><a href="">+255 754 536 630</a><br>
                <strong>Tel: </strong><a href="tel:+255 776 374 466">+255 776 374 466</a><br>
                <strong>Email: </strong> <a href="emailto:mwatimajuma@gmail.com">mwatimajuma@gmail.com</a> <br>
                </p>

            </div>

            <div class="tm-form-section-tag">
                <div class="tm-bg-secondary tm-text-white tm-block-pad tm-form-section-tag-inner">
                    <header>
                        <h2>Call us to make reservation</h2>
                    </header>
                    <p>
                        At only 50$ you can experience this one of a kind adventure.
                    </p>
                </div>
            </div>
        </div>

    </main>
    <script src="/farmTour/js/jquery-3.3.1.min.js"></script>
    <!-- https://jquery.com/download/ -->
    <script>

        let callAdjustLayout;
        let currentLayout = "desktop",
            nextLayout = "desktop";

        /**
         * detect IE
         * returns version of IE or false, if browser is not Internet Explorer
         */
        function detectIE() {
            var ua = window.navigator.userAgent;

            var msie = ua.indexOf('MSIE ');
            if (msie > 0) {
                // IE 10 or older => return version number
                return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
            }

            var trident = ua.indexOf('Trident/');
            if (trident > 0) {
                // IE 11 => return version number
                var rv = ua.indexOf('rv:');
                return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
            }

            var edge = ua.indexOf('Edge/');
            if (edge > 0) {
                // Edge (IE 12+) => return version number
                return parseInt(ua.substring(edge + 5, ua.indexOf('.', edge)), 10);
            }

            // other browser
            return false;
        }

        // Adjust layout based on the browser width
        function adjustLayout() {
            let block1, block2, block3, block4, block5, block6, block7, block8, block9;

            if (window.innerWidth <= 1199) {
                // Mobile layout
                nextLayout = "mobile";
                block1 = $("div[data-mobile-seq-no='1']");
                block2 = $("div[data-mobile-seq-no='2']");
                block3 = $("div[data-mobile-seq-no='3']");
                block4 = $("div[data-mobile-seq-no='4']");
                block5 = $("div[data-mobile-seq-no='5']");
                block6 = $("div[data-mobile-seq-no='6']");
                block7 = $("div[data-mobile-seq-no='7']");
                block8 = $("div[data-mobile-seq-no='8']");
                block9 = $("div[data-mobile-seq-no='9']");
            } else {
                // Desktop layout
                nextLayout = "desktop";
                block1 = $("div[data-desktop-seq-no='1']");
                block2 = $("div[data-desktop-seq-no='2']");
                block3 = $("div[data-desktop-seq-no='3']");
                block4 = $("div[data-desktop-seq-no='4']");
                block5 = $("div[data-desktop-seq-no='5']");
                block6 = $("div[data-desktop-seq-no='6']");
                block7 = $("div[data-desktop-seq-no='7']");
                block8 = $("div[data-desktop-seq-no='8']");
                block9 = $("div[data-desktop-seq-no='9']");
            }

            if (nextLayout !== currentLayout) {
                // Reorder blocks based on their seq no
                block1.after(block2.detach());
                block2.after(block3.detach());
                block3.after(block4.detach());
                block4.after(block5.detach());
                block5.after(block6.detach());
                block6.after(block7.detach());
                block7.after(block8.detach());
                block8.after(block9.detach());
                currentLayout = nextLayout;
            }
        }

        // Adjust layout upon window resize
        window.onresize = function () {
            clearTimeout(callAdjustLayout);
            callAdjustLayout = setTimeout(adjustLayout, 100);
        }

        // DOM is ready
        $(function () {
            if (detectIE()) {
                alert('Please use the latest version of Chrome or Firefox for best browsing experience.');
            }

            adjustLayout();
        })
    </script>
</body>

</html>